/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device;

import jemu.core.Util;
import jemu.core.device.Device;
import jemu.core.device.printer.TextPrinter;
import jemu.settings.Palette;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Desktop;
import jemu.ui.DesktopHelper;
import jemu.ui.JEMU;
import jemu.ui.Switches;

public class DeviceMapping {
    protected Device device;
    protected int mask;
    protected int test;
    protected int printer;
    int digicount = 0;
    int drum = 0;
    public boolean paintstarted = false;
    int ink;
    int red;
    int green;
    int blue;
    boolean setink = false;

    public DeviceMapping(Device device, int mask, int test2) {
        this.device = device;
        this.mask = mask;
        this.test = test2;
    }

    public int readPort(int port) {
        if (port == 61439 && Switches.Expansion) {
            return 160;
        }
        return (port & this.mask) == this.test ? this.device.readPort(port) : -1;
    }

    public void writePort(int port, int value) {
        if (Switches.Expansion && !Switches.amdrum) {
            if (port == 65360) {
                this.ink = value & 0x1F;
                CPC.inksEdited = true;
                GateArray.setInk(this.ink, this.red, this.green, this.blue);
                Switches.monitormode = 0;
                String i = "" + this.ink;
                if (this.ink < 10) {
                    i = "0" + i;
                }
                Palette.set("ink_" + i, "" + Util.hex((byte)this.red) + Util.hex((byte)this.green) + Util.hex((byte)this.blue));
                DesktopHelper.updatePalette(this.ink);
            }
            if (port == 65296) {
                CPC.inksEdited = false;
                GateArray.resetCPCColours();
                GateArray.writePalette();
                Desktop.updatePalette(false);
            }
            if (port == 65312) {
                this.red = value & 0xFF;
            }
            if (port == 65328) {
                this.green = value & 0xFF;
            }
            if (port == 65344) {
                this.blue = value & 0xFF;
            }
        }
        if ((port & this.mask) == this.test) {
            this.device.writePort(port, value);
        }
        if (Switches.Expansion && port == 65280) {
            if (value == 219) {
                JEMU.screentimer = 1;
            }
            if (value == 213) {
                JEMU.screenshottimer = 1;
            }
            if (value == 214) {
                JEMU.dsksavetimer = 1;
            }
            if (value == 215) {
                Switches.ScanLines = true;
            }
            if (value == 216) {
                Switches.ScanLines = false;
            }
            if (value == 217) {
                JEMU.dskmaketimer = 1;
            }
            if (value == 255) {
                TextPrinter.MakeInvisible();
            }
            if (value == 208) {
                Switches.monitormode = 0;
            }
            if (value == 209) {
                GateArray.cpc.Digitracker();
            }
            if (value == 210) {
                Switches.monitormode = 0;
            }
            if (value == 210) {
                Switches.monitormode = 2;
            }
            if (value == 211) {
                Switches.monitormode = 3;
            }
            if (value == 212) {
                JEMU.makeassembler = true;
            }
            if (value == 221) {
                GateArray.cpc.plotlogo = 15;
            }
            if (value == 222) {
                TextPrinter.Smaller();
            }
            if (value == 223) {
                TextPrinter.Bigger();
            }
            if (value == 239) {
                System.exit(0);
            }
            if (value == 254) {
                TextPrinter.MakeVisible();
            }
            if (value == 252) {
                TextPrinter.ClearPrinter();
            }
            if (value == 253) {
                TextPrinter.Copy();
            }
            if (value == 250) {
                Switches.Printer = false;
                TextPrinter.OnlineButton();
            }
            if (value == 251) {
                Switches.Printer = true;
                TextPrinter.OnlineButton();
            }
            if (value == 224) {
                TextPrinter.FontName = TextPrinter.FontName1;
                TextPrinter.setFont();
            }
            if (value == 225) {
                TextPrinter.FontName = TextPrinter.FontName2;
                TextPrinter.setFont();
            }
            if (value == 226) {
                TextPrinter.FontName = TextPrinter.FontName3;
                TextPrinter.setFont();
            }
            if (value == 227) {
                TextPrinter.FontName = TextPrinter.FontName4;
                TextPrinter.setFont();
            }
            if (value == 228) {
                TextPrinter.FontName = TextPrinter.FontName5;
                TextPrinter.setFont();
            }
            if (value == 229) {
                TextPrinter.FontName = TextPrinter.FontName6;
                TextPrinter.setFont();
            }
            if (value == 230) {
                TextPrinter.FontName = TextPrinter.FontName7;
                TextPrinter.setFont();
            }
            if (value == 231) {
                TextPrinter.FontName = TextPrinter.FontName8;
                TextPrinter.setFont();
            }
            if (value == 232) {
                TextPrinter.FontName = TextPrinter.FontName9;
                TextPrinter.setFont();
            }
        }
        if (Switches.Expansion && port == 65281 && value != 0) {
            TextPrinter.textSize = value;
            TextPrinter.setFont();
        }
    }
}

